/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

    When writing applications with worlds, you need to additionaly include all the Headers generated by the World Editor
    these Headers are stored in the "enum/_enums.h" file in your Game Data folder
    for more information about Enums and Headers please check World Editor documentation

/******************************************************************************/
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
Game::ObjMemx<Game::Static> Statics; // container for static    objects
Game::ObjMemx<Game::Item  > Items;   // container for item      objects
Game::ObjMemx<Game::Chr   > Chrs;    // container for character objects
/******************************************************************************/
void InitPre()
{
   App.name="World Manager";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024);

   Cam.dist =10;
   Cam.yaw  =-PI_4;
   Cam.pitch=-0.5;
   Cam.at.set(16,0,16);
}
/******************************************************************************/
Bool Init()
{
   Physics.create();

   Game::World.init(); // initialize world, optionally you can change default parameters here

   // once the world is inited, we need to tell the world 'which class is which', this is done by assigning memory containers to certain Object Types defined in Game Enums (which were used in the World Editor)
   Game::World.setType(Statics,OBJ_STATIC)  // set 'Statics' memory container for 'OBJ_STATIC' objects
              .setType(Items  ,OBJ_ITEM  )  // set 'Items'   memory container for 'OBJ_ITEM'   objects
              .setType(Chrs   ,OBJ_CHR   ); // set 'Chrs'  ' memory container for 'OBJ_CHR'    objects

   // now when the engine is set up properly we can start a 'new game' with a builded world
   Game::World.New("world/sample"); // create the world by giving path to builded world

   // when the world is loaded it doesn't actually load all the terrain and objects into memory
   // it loads only information about them
   // you need to tell the world which terrain and objects you need to use at the moment
   // to do that call:
   Game::World.update(Cam.at); // which updates world to use only terrain and objects at given position, here camera position is used

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   Game::World.update(Cam.at); // update world to given position

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw(); // draw world (this is done outside of 'switch(Renderer())' because world automatically detects active rendering mode)

   switch(Renderer())
   {
      case RM_LIGHT:
         LightDir(1,!Vec(1,-1,1)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
